/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  lcd.h
//  Control of a HD47780 compatible LCD
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef LCD_H
#define LCD_H


// definitions for display size
#define LCD_LINES			2		// number of visible lines of the display
#define LCD_DISP_LENGTH		16		// visible characters per line of the display
#define LCD_LINE_LENGTH		0x40	// internal line length of the display
#define LCD_START_LINE1		0x00	// DDRAM address of first char of line 1
#define LCD_START_LINE2		0x40	// DDRAM address of first char of line 2
#define LCD_START_LINE3 	0x14	// DDRAM address of first char of line 3
#define LCD_START_LINE4		0x54	// DDRAM address of first char of line 4
#define LCD_WRAP_LINES		0		// 0: no wrap, 1: wrap at end of visible line


// pin and port definitions
#define LCD_DATA0_POUT		P1OUT	// output port for 4bit data bit 0
#define LCD_DATA1_POUT		P1OUT	// output port for 4bit data bit 1
#define LCD_DATA2_POUT		P1OUT	// output port for 4bit data bit 2
#define LCD_DATA3_POUT		P1OUT	// output port for 4bit data bit 3

#define LCD_DATA0_PSEL		P1SEL	// function select register for data bit 0
#define LCD_DATA1_PSEL		P1SEL	// function select register for data bit 1
#define LCD_DATA2_PSEL		P1SEL	// function select register for data bit 2
#define LCD_DATA3_PSEL		P1SEL	// function select register for data bit 3

#define LCD_DATA0_DDR		P1DIR	// data direction register for data bit 0
#define LCD_DATA1_DDR		P1DIR	// data direction register for data bit 1
#define LCD_DATA2_DDR		P1DIR	// data direction register for data bit 2
#define LCD_DATA3_DDR		P1DIR	// data direction register for data bit 3

#define LCD_DATA0_REN		P1REN	// pullup resistor register for data bit 0
#define LCD_DATA1_REN		P1REN	// pullup resistor register for data bit 1
#define LCD_DATA2_REN		P1REN	// pullup resistor register for data bit 2
#define LCD_DATA3_REN		P1REN	// pullup resistor register for data bit 3

#define LCD_DATA0_PIN		P1IN	// input port for 4bit data bit 0
#define LCD_DATA1_PIN		P1IN	// input port for 4bit data bit 1
#define LCD_DATA2_PIN		P1IN	// input port for 4bit data bit 2
#define LCD_DATA3_PIN		P1IN	// input port for 4bit data bit 3

#define LCD_DATA0_BIT		BIT7	// bit number for data bit 0 (D4 on LCD)
#define LCD_DATA1_BIT		BIT6	// bit number for data bit 1 (D5 on LCD)
#define LCD_DATA2_BIT		BIT5	// bit number for data bit 2 (D6 on LCD)
#define LCD_DATA3_BIT		BIT4	// bit number for data bit 3 (D7 on LCD)

#define LCD_RS_POUT			P1OUT	// output port for RS line
#define LCD_RS_PSEL			P1SEL	// function select register for RS line
#define LCD_RS_DDR			P1DIR	// data direction register for RS line
#define LCD_RS_BIT			BIT1	// bit for RS line

#define LCD_RW_POUT			P1OUT	// port for RW line
#define LCD_RW_PSEL			P1SEL	// function select register for RW line
#define LCD_RW_DDR			P1DIR	// data direction register for RW line
#define LCD_RW_BIT			BIT2	// bit for RW line

#define LCD_EN_POUT			P1OUT	// port for Enable line
#define LCD_EN_PSEL			P1SEL	// function select register for Enable line
#define LCD_EN_DDR			P1DIR	// data direction register for Enable line
#define LCD_EN_BIT			BIT3	// bit for Enable line

#define LCD_IO_DATA			0xC000	// A15=E=1, A14=RS=1
#define LCD_IO_FUNCTION		0x8000	// A15=E=1, A14=RS=0
#define LCD_IO_READ			0x0100	// A8 =R/W=1 (R/W: 1=Read, 0=Write)


// Definitions for LCD command instructions
// The constants define the various LCD controller instructions which can be
// passed to the function lcd_command()
// See HD44780 data sheet for a complete description.
#define LCD_CLR					0		// DB0: clear display
#define LCD_HOME				1		// DB1: return to home position
#define LCD_ENTRY_MODE			2		// DB2: set entry mode
#define LCD_ENTRY_INC			1		// DB1: 1=increment, 0=decrement
#define LCD_ENTRY_SHIFT			0		// DB2: 1=display shift on
#define LCD_ON					3		// DB3: turn lcd/cursor on
#define LCD_ON_DISPLAY			2		// DB2: turn display on
#define LCD_ON_CURSOR			1		// DB1: turn cursor on
#define LCD_ON_BLINK			0		// DB0: blinking cursor
#define LCD_MOVE				4		// DB4: move cursor/display
#define LCD_MOVE_DISP			3		// DB3: move display (0-> cursor)
#define LCD_MOVE_RIGHT			2		// DB2: move right (0-> left)
#define LCD_FUNCTION			5		// DB5: function set
#define LCD_FUNCTION_8BIT		4		// DB4: set 8BIT mode (0->4BIT mode)
#define LCD_FUNCTION_2LINES		3		// DB3: two lines (0->one line)
#define LCD_FUNCTION_10DOTS		2		// DB2: 5x10 font (0->5x7 font)
#define LCD_CGRAM				6		// DB6: set CG RAM address
#define LCD_DDRAM				7		// DB7: set DD RAM address
#define LCD_BUSY				7		// DB7: LCD is busy


//set entry mode: display shift on/off, dec/inc cursor move direction
#define LCD_ENTRY_DEC			0x04	// display shift off, dec cursor move dir
#define LCD_ENTRY_DEC_SHIFT		0x05	// display shift on,  dec cursor move dir
#define LCD_ENTRY_INC_			0x06	// display shift off, inc cursor move dir
#define LCD_ENTRY_INC_SHIFT		0x07	// display shift on,  inc cursor move dir


// display on/off, cursor on/off, blinking char at cursor position
#define LCD_DISP_OFF				0x08   // display off
#define LCD_DISP_ON					0x0C   // display on, cursor off
#define LCD_DISP_ON_BLINK			0x0D   // display on, cursor off, blink char
#define LCD_DISP_ON_CURSOR			0x0E   // display on, cursor on
#define LCD_DISP_ON_CURSOR_BLINK	0x0F   // display on, cursor on, blink char


// move cursor/shift display
#define LCD_MOVE_CURSOR_LEFT	0x10	// move cursor left  (decrement)
#define LCD_MOVE_CURSOR_RIGHT	0x14	// move cursor right (increment)
#define LCD_MOVE_DISP_LEFT		0x18	// shift display left
#define LCD_MOVE_DISP_RIGHT		0x1C	// shift display right


// function set: set interface data length and number of display lines
#define LCD_FUNCTION_4BIT_1LINE		0x20	// 4-bit interface, single line, 5x7 dots
#define LCD_FUNCTION_4BIT_2LINES	0x28	// 4-bit interface, dual line,   5x7 dots
#define LCD_FUNCTION_8BIT_1LINE		0x30	// 8-bit interface, single line, 5x7 dots
#define LCD_FUNCTION_8BIT_2LINES	0x38	// 8-bit interface, dual line,   5x7 dots


#define LCD_MODE_DEFAULT     ((1<<LCD_ENTRY_MODE) | (1<<LCD_ENTRY_INC) )


// Initialize display and select type of cursor
// LCD_DISP_OFF					display off
// LCD_DISP_ON					display on, cursor off
// LCD_DISP_ON_CURSOR			display on, cursor on
// LCD_DISP_ON_CURSOR_BLINK		display on, cursor on flashing             
extern void lcd_init(unsigned int dispAttr);

// Clear display and set cursor to home position
extern void lcd_clrscr(void);

// Set cursor to home position
extern void lcd_home(void);

// Set cursor to specified position
// x: horizontal position	(0: left most position)
// y: vertical position		(0: first line)
extern void lcd_gotoxy(unsigned int x, unsigned int y);

// Display character at current cursor position
// c: character to be displayed                                       
extern void lcd_putc(char c);

// Display string without auto linefeed
// s: string to be displayed                                        
extern void lcd_puts(const char *s);

// Display an integer
// i: integer to be displayed
extern void lcd_puti(unsigned int i);

// Display string from program memory without auto linefeed
// s: string from program memory be be displayed                                        
extern void lcd_puts_p(const char *progmem_s);

// Send LCD controller instruction command
// cmd: instruction to send to LCD controller, see HD44780 data sheet
extern void lcd_command(unsigned int cmd);

// Send data byte to LCD controller
// Similar to lcd_putc(), but without interpreting LF
// data: byte to send to LCD controller, see HD44780 data sheet
extern void lcd_data(unsigned int data);



#endif /*LCD_H_*/
